 /* 'mrScreen.h' */

 /* Nagowek typw bazowych */
#include "mrDatatypes.h"
 /* Nagwek funkcji czasu */
#include "mrTimer.h"
 /* Nagwek definicji bdw Mirus */
#include "mrError.h"
 /* Plik nagwka Windows */
#include <windows.h> 
 /* Plik nagwka grafiki DirectX */
#include <d3d8.h> 
 /* Plik nagwka moduu matematycznego C++ */
#include <math.h> 
 /* Plik nagwka Assert */
#include <assert.h> 

 /* Zaczaj plik tylko raz */
#pragma once

 /* Wasna struktura wierchoka Mirus */
class mrVertex
{
public:
  /* Pozycja przetransformowana */ 
 FLOAT m_fX, m_fY, m_fZ, m_fRHW;
  /* Kolor */
 DWORD m_iColor;
  /* Wsprzdne tekstury */
 FLOAT m_ftU, m_ftV;
};

 /* Wasny typ wierzchoka Mirus */
#define D3DFVF_MIRUSVERTEX (D3DFVF_XYZRHW|D3DFVF_DIFFUSE|D3DFVF_TEX1)

 /* Klasa ekranu Mirus */
class mrScreen
{
protected:
 LPDIRECT3D8        m_pkD3D;
 LPDIRECT3DDEVICE8  m_pkD3DDevice;

 mrUInt32           m_iFPS;
 HWND               m_hWindow;

 mrTimer            m_kTimer;

 mrUInt32           m_iFormat;

  /* singleton */
 static mrScreen *  m_pkSingleton;

public:
  /* Konstruktory / Destruktor */
 mrScreen (void);
 mrScreen (HWND hWindow);

 ~mrScreen (void);

  /* Metody manipulujce ekranem */
 mrError32 Init (HWND hWindow);
 mrError32 SetMode (mrUInt32 iFullscreen, mrUInt16 iWidth, 
                    mrUInt16 iHeight, mrUInt16 iDepth, 
                    bool bHardware); 

  /* Procedury renderujce */
 mrError32 Clear (mrUInt8 iRed, mrUInt8 iGreen, mrUInt8 iBlue, 
                  mrUInt8 iAlpha);
 mrError32 StartFrame (void);
 mrError32 EndFrame (void);

  /* Metody rysujce */
 mrError32 DrawLine (mrReal32 fX1, mrReal32 fY1, 
                     mrReal32 fX2, mrReal32 fY2, 
                     mrUInt8 iRed, mrUInt8 iGreen, 
                     mrUInt8 iBlue, mrUInt8 iAlpha);
 mrError32 DrawRectangle (mrReal32 fX1, mrReal32 fY1, 
                          mrReal32 fX2, mrReal32 fY2, 
                          mrUInt8 iRed, mrUInt8 iGreen, 
                          mrUInt8 iBlue, mrUInt8 iAlpha);
 mrError32 DrawCircle (mrReal32 fCenterX, mrReal32 fCenterY, 
                       mrReal32 iRadius, mrUInt8 iRed, 
                       mrUInt8 iGreen, mrUInt8 iBlue, mrUInt8 iAlpha,
                       mrUInt32 iVertices);

  /* Inne metody */
 mrBool32 IsModeSupported (mrUInt16 iWidth, mrUInt16 iHeight, 
                           mrUInt16 iDepth);
 void ShowCursor (mrUInt32 iShowCursor);

  /* Metody obsugowe */
 LPDIRECT3DDEVICE8 GetDevice (void);
 mrUInt32 GetFPS (void);
 mrUInt32 GetFormat (void);
 
 mrUInt32 GetBitdepth (void);

  /* singleton */
 static mrScreen * GetSingleton (void);
};
